var siguiente=$("#next").val();
var anterior=$("#prev").val();
var duplicado=false;

jQuery(function($){

	$("#imprimirFicha").rup_tooltip();
	$("#docPlan").rup_tooltip();
	$("#docPlanOff").rup_tooltip();
	
	if (!mostrarLugarDuracion){
		$("#seccionDatosLugar").css("display",'none');
		$("#seccionDatosDuracion").css("display",'none');
	}	
	
	$(".doc-slide").click(function(){
		var ID = $(this).attr("id");
		if($(this).hasClass("activoOff")){
			$(this).removeClass("activoOff");
			$(this).addClass("activoOn");
			$("#"+ID).next().slideDown("slow");
		}else{
			$(this).removeClass("activoOn");
			$(this).addClass("activoOff");
			$("#"+ID).next().slideUp("slow");
		}
	});	
	
	// FUNCIONES BOTONERA
	var exp = {
			volver:function(){
				location.href = $.rup.CTX_PATH + "expedientesFiltro/backToMaint";
			},next:function(){
				location.href = $.rup.CTX_PATH + "ab03b10t00/irDetalle/"+siguiente+"?tab="+tabActiva;
			},prev:function(){
				location.href = $.rup.CTX_PATH + "ab03b10t00/irDetalle/"+anterior+"?tab="+tabActiva;
			}
	};
	
	/*
	 * TOOLBAR  
	 * Se van aÃ±adiendo botones por la izquierda, segun se cumplan diferentes requisitos.
	 */
	var $botonera = $("#expedientes_toolbar");
	if(siguiente != ""){
		$botonera.addButton({i18nCaption:"next",right:true,click:exp.next},$.rup.i18n.app["botones"]);	
	}
	$botonera.addButton({i18nCaption:"volver",right:true,click:exp.volver},$.rup.i18n.app["botones"]);
	if(anterior != ""){
		$botonera.addButton({i18nCaption:"prev",right:true,click:exp.prev},$.rup.i18n.app["botones"]);
	}
	
	$("#tabs").rup_tabs({
		tabs : [
			{i18nCaption:$.rup.i18n.app.tabsDetExp.datosExpediente, layer:".datExp"},
			{i18nCaption:$.rup.i18n.app.tabsDetExp.datosEmpresa, layer:".datEmp"},
			{i18nCaption:$.rup.i18n.app.tabsDetExp.tramitacion, layer:".tram"}],
			select:function(event,ui){
				return validarParaCambioPestana(event,ui);
			}
	});
	$("#tabs").rup_tabs("selectTab",{ idTab: "tabs", position: tabActiva});
	
	cargarCombos();
	
	$("#tramitacion_toolbar").rup_toolbar({
		buttons:
			[{id:"Documentos", i18nCaption:$.rup.i18n.app.botones.verOcultarDocumentos, right:true, click: verOcultarTodos}]
	});

	if(!estadoCierreRealizado){
		if(esUsuarioModificacion){
			//mostrar boton de cierre siempre que no esté creado el tramite de cierre
			$("#tramitacion_toolbar").addButton({id:"cerrarExpediente",i18nCaption:$.rup.i18n.app.botones.cerrarExpediente,right:false, click:function(event){cerrarExpediente(event);}});
		
			//Botonera crear informes-->Mostrar boton resolucion solo si F= 1-T=2,3,4|| F=2-T=3,4,5
			if(mostrarBotonResol){
				$("#tramitacion_toolbar").addButton({id:"Resolucion", i18nCaption:$.rup.i18n.app.botones.Resolucion, right:false, click: function(event){resolucion(event);}});
			}
			
			if(mostrarBotonRequer){
				$("#tramitacion_toolbar").addButton({id:"Requerimiento", i18nCaption:$.rup.i18n.app.botones.Requerimiento, right:false, click: function(event){requerimiento(event);}});
			}
			
			//mostrar boton recurso de alzada solo F=6-T=2
			if (mostrarBotonRecal){
				$("#tramitacion_toolbar").addButton({id:"RecursoAlzada", i18nCaption:$.rup.i18n.app.botones.RecursoAlzada, right:false, click: function(event){recursoAlzada(event);}});
			}
			
			//mostrar boton resolucion desestimiento solo F=7-T=2
			if (mostrarBotonDesis){
				$("#tramitacion_toolbar").addButton({id:"Resol. desistimiento", i18nCaption:$.rup.i18n.app.botones.ResolDesistimiento, right:false, click: function(event){resolDesestimiento(event);}});
			}
		}
		
		//Se muestra el boton de aportar informe de osalan y de inspecci�n, siempre que se haya dado de alta el expediente en mis gestiones
		// y el usuario no sea direccin.
		if (esUsuarioOsalanTer && mostrarBotonApOsalan) {
			$("#tramitacion_toolbar").addButton({id:"AportOsalan", i18nCaption:$.rup.i18n.app.botones.InformeOsalan, right:false, click: function(event){aportarInforme(event, "osalan");}});
		}
		if (esUsuarioInspeccionTer && mostrarBotonApInsp) {
			$("#tramitacion_toolbar").addButton({id:"AportInspeccion", i18nCaption:$.rup.i18n.app.botones.InformeInspeccion, right:false, click: function(event){aportarInforme(event, "inspeccion");}});
		}
	}
	
	//Si el expediente está cerrado, quitamos todos los botones y deshabilitamos los campos
	if(!estadoCierreRealizado){
		if(!esUsuarioModificacion){
			deshabilitarCampos();
			
			$("#fechIniTrabajo010").rup_date({
				disabled:true
			});
			
			if(esUsuarioModifOsalanTer){
				//Botonera guardar datos expediente
				$("#guardarDatExp_toolbar").rup_toolbar({
					buttons:
						[{id:"Guardar", i18nCaption:$.rup.i18n.app.botones.Guardar, left:true,click: modificarExpediente}]
				});
			}else{
				$("#fechaVisita010").rup_date({
					disabled:true
				});
			}
		}else{
			if (["01","20","48"].indexOf($("#provSolicitante").val()) != -1){
				$("#numRera047").attr("readonly", true);
			}else{
				//Botonera guardar datos de la empresa
				$("#guardarDatEmp_toolbar").rup_toolbar({
					buttons:
						[{id:"Guardar", i18nCaption:$.rup.i18n.app.botones.Guardar, left:true,click: modificarExpediente}]
				});
			}
			
			//Botonera guardar datos expediente
			$("#guardarDatExp_toolbar").rup_toolbar({
				buttons:
					[{id:"Guardar", i18nCaption:$.rup.i18n.app.botones.Guardar, left:true,click: modificarExpediente}]
			});
		}
		
		recargarTablaTrabajadores=function(){
			$("#trabajadores").rup_table("reloadGrid", false);
		};
		
		if(esUsuarioModificacion){
			$("#trabajadores").rup_table({
				url: $.rup.CTX_PATH +"ab03b32t00/buscarTrabajadores",
				colNames: ["",
				    "",
				    "",
					$.rup.i18n.app.trabajadores.numDocumento,
					$.rup.i18n.app.trabajadores.nombre,
					$.rup.i18n.app.trabajadores.apellido1,
					$.rup.i18n.app.trabajadores.apellido2,
					$.rup.i18n.app.trabajadores.numSegSocial,
					$.rup.i18n.app.trabajadores.fechaAptitud,
					$.rup.i18n.app.trabajadores.titulaciones,
					$.rup.i18n.app.mantenimientos.ActiSN
				],
				colModel: [
					{ 	name: "id032", 
						align: "left", 
						width:70, 
						editable: false, 
						fixed: false, 
						hidden: true
					},
					{ 	name: "id047Empresa", 
						align: "left", 
						width:70, 
						editable: false, 
						fixed: false, 
						hidden: true
					},
					{ 	name: "tipoDoc044", 
						align: "left", 
						width:70, 
						editable: true,
						editableOnEdit:false,
						fixed: false, 
						hidden: true,
						sortable:true
					},
					{ 	name: "numDocumento032",
						index: "nif032",
						align: "left", 
						width: 90, 
						editable:true, 
						editableOnEdit:false,
						fixed: false, 
						hidden: false, 
						sortable: true,
						formatter: ab03bUtils.tabla.formatterNifUpperCase
					},
					{ 	name: "nombre032", 
						align: "left", 
						width: 90, 
						editable: true, 
						fixed: false, 
						hidden: false, 
						sortable: true
					},
					{ 	name: "apellido1032", 
						align: "left", 
						width: 130, 
						editable: true, 
						fixed: false, 
						hidden: false, 
						sortable: true
					},
					{ 	name: "apellido2032", 
						align: "left", 
						width: 130, 
						editable: true, 
						fixed: false, 
						hidden: false, 
						sortable: true
					},
					{ 	name: "nss032", 
						align: "left", 
						width: 120, 
						editable: true, 
						fixed: false, 
						hidden: false, 
						sortable: true
					},
					{ 	name: "fechaAptitud032Str", 
						align: "left", 
						width: 100, 
						editable: true, 
						fixed: false, 
						hidden: false, 
						sortable: true
					},
					{ 	name: "titulaciones032", 
						align: "left", 
						width: 180, 
						editable: true, 
						fixed: false, 
						hidden: false, 
						sortable: true
					},
					{ 	name: "activo033", 
						index: "activo033",
						align: "center",
						edittype: "checkbox",
						formatter: "checkbox",
						editoptions: {
							value: "1:0"
						}, 
						width: 90,
						editable:true,
						fixed: false, 
						hidden: false, 
						sortable: true
					}
		        ],
		        model:"Ab03b32t00",
		        usePlugins:[
					"formEdit",
		        	"feedback",
					"toolbar",
		        	"fluid"
		        ],
		        fluid: {
		        	baseLayer: "seccionTrabajadores"
		        },
		        feedback:{
					config:{
						block: false
					}
				},
				toolbar: {
		        	showOperations: {       		
		        		'clone': false,
		        		'delete': false
		        	}
		        },
		        formEdit:{
		        	detailForm: "#trabajadores_detail_div",
					fillDataMethod: "clientSide",
					editOptions: {
						ajaxEditOptions: {
							success: recargarTablaTrabajadores
						}
					},
		         	validate:{ 
		         		feedback:$("#trabajadores_detail_feedback"),
		    			rules:{
		    				"numDocumento032":{
		    					required: true,
		    					tipoDocumento:true
		    				},
		    				"nombre032":{
		    					required: true
		    				},
		    				"apellido1032":{
		    					required: true
		    				},
		    				"fechaAptitud032Str":{
		    					required: true,
		    					date: true
		    				},
		    				"tipoDoc044":{
		    					required:true
		    				}
		    			}
		         	}
		        },
		        primaryKey: "id032",
				sortname: "id032",
				sortorder: "asc",
				loadOnStartUp: true
			});
		}else{
			$("#trabajadores").rup_table({
				url: $.rup.CTX_PATH +"ab03b32t00/buscarTrabajadores",
				colNames: ["",
				    "",
				    "",
					$.rup.i18n.app.trabajadores.numDocumento,
					$.rup.i18n.app.trabajadores.nombre,
					$.rup.i18n.app.trabajadores.apellido1,
					$.rup.i18n.app.trabajadores.apellido2,
					$.rup.i18n.app.trabajadores.numSegSocial,
					$.rup.i18n.app.trabajadores.fechaAptitud,
					$.rup.i18n.app.trabajadores.titulaciones,
					$.rup.i18n.app.mantenimientos.ActiSN
				],
				colModel: [
					{ 	name: "id032", 
						align: "left", 
						width:70, 
						editable: false, 
						fixed: false, 
						hidden: true
					},
					{ 	name: "id047Empresa", 
						align: "left", 
						width:70, 
						editable: false, 
						fixed: false, 
						hidden: true
					},
					{ 	name: "tipoDoc044", 
						align: "left", 
						width:70, 
						editable: true,
						editableOnEdit:false,
						fixed: false, 
						hidden: true,
						sortable:true
					},
					{ 	name: "numDocumento032",
						index: "nif032",
						align: "left", 
						width: 90, 
						editable:true, 
						editableOnEdit:false,
						fixed: false, 
						hidden: false, 
						sortable: true,
						formatter: ab03bUtils.tabla.formatterNifUpperCase
					},
					{ 	name: "nombre032", 
						align: "left", 
						width: 90, 
						editable: true, 
						fixed: false, 
						hidden: false, 
						sortable: true
					},
					{ 	name: "apellido1032", 
						align: "left", 
						width: 130, 
						editable: true, 
						fixed: false, 
						hidden: false, 
						sortable: true
					},
					{ 	name: "apellido2032", 
						align: "left", 
						width: 130, 
						editable: true, 
						fixed: false, 
						hidden: false, 
						sortable: true
					},
					{ 	name: "nss032", 
						align: "left", 
						width: 120, 
						editable: true, 
						fixed: false, 
						hidden: false, 
						sortable: true
					},
					{ 	name: "fechaAptitud032Str", 
						align: "left", 
						width: 100, 
						editable: true, 
						fixed: false, 
						hidden: false, 
						sortable: true
					},
					{ 	name: "titulaciones032", 
						align: "left", 
						width: 180, 
						editable: true, 
						fixed: false, 
						hidden: false, 
						sortable: true
					},
					{ 	name: "activo033", 
						index: "activo033",
						align: "center",
						edittype: "checkbox",
						formatter: "checkbox",
						editoptions: {
							value: "1:0"
						}, 
						width: 90,
						editable:true,
						fixed: false, 
						hidden: false, 
						sortable: true
					}
		        ],
		        model:"Ab03b32t00",
		        usePlugins:[
		        	"feedback",
		        	"fluid"
		        ],
		        core: {	
		        	showOperations: {
		        		'delete': false
		        	}
		        },
		        fluid: {
		        	baseLayer: "seccionTrabajadores"
		        },
		        feedback:{
					config:{
						block: false
					} 
		        },
		        primaryKey: "id032",
				sortname: "id032",
				sortorder: "asc",
				loadOnStartUp: true
			});
		}
	}else{
		deshabilitarCampos();
		
		$("#fechIniTrabajo010").rup_date({
			disabled:true
		});
		
		$("#fechaVisita010").rup_date({
			disabled:true
		});
		
		$("#trabajadores").rup_table({
			url: $.rup.CTX_PATH +"ab03b32t00/buscarTrabajadores",
			colNames: ["",
			    "",
			    "",
				$.rup.i18n.app.trabajadores.numDocumento,
				$.rup.i18n.app.trabajadores.nombre,
				$.rup.i18n.app.trabajadores.apellido1,
				$.rup.i18n.app.trabajadores.apellido2,
				$.rup.i18n.app.trabajadores.numSegSocial,
				$.rup.i18n.app.trabajadores.fechaAptitud,
				$.rup.i18n.app.trabajadores.titulaciones,
				$.rup.i18n.app.mantenimientos.ActiSN
			],
			colModel: [
				{ 	name: "id032", 
					align: "left", 
					width:70, 
					editable: false, 
					fixed: false, 
					hidden: true
				},
				{ 	name: "id047Empresa", 
					align: "left", 
					width:70, 
					editable: false, 
					fixed: false, 
					hidden: true
				},
				{ 	name: "tipoDoc044", 
					align: "left", 
					width:70, 
					editable: true,
					editableOnEdit:false,
					fixed: false, 
					hidden: true,
					sortable:true
				},
				{ 	name: "numDocumento032",
					index: "nif032",
					align: "left", 
					width: 90, 
					editable:true, 
					editableOnEdit:false,
					fixed: false, 
					hidden: false, 
					sortable: true,
					formatter: ab03bUtils.tabla.formatterNifUpperCase
				},
				{ 	name: "nombre032", 
					align: "left", 
					width: 90, 
					editable: true, 
					fixed: false, 
					hidden: false, 
					sortable: true
				},
				{ 	name: "apellido1032", 
					align: "left", 
					width: 130, 
					editable: true, 
					fixed: false, 
					hidden: false, 
					sortable: true
				},
				{ 	name: "apellido2032", 
					align: "left", 
					width: 130, 
					editable: true, 
					fixed: false, 
					hidden: false, 
					sortable: true
				},
				{ 	name: "nss032", 
					align: "left", 
					width: 120, 
					editable: true, 
					fixed: false, 
					hidden: false, 
					sortable: true
				},
				{ 	name: "fechaAptitud032Str", 
					align: "left", 
					width: 100, 
					editable: true, 
					fixed: false, 
					hidden: false, 
					sortable: true
				},
				{ 	name: "titulaciones032", 
					align: "left", 
					width: 180, 
					editable: true, 
					fixed: false, 
					hidden: false, 
					sortable: true
				},
				{ 	name: "activo033", 
					index: "activo033",
					align: "center",
					edittype: "checkbox",
					formatter: "checkbox",
					editoptions: {
						value: "1:0"
					}, 
					width: 90,
					editable:true,
					fixed: false, 
					hidden: false, 
					sortable: true
				}
	        ],
	        model:"Ab03b32t00",
	        usePlugins:[
	        	"feedback",
	        	"fluid"
	        ],
	        core: {	
	        	showOperations: {
	        		'delete': false
	        	}
	        },
	        fluid: {
	        	baseLayer: "seccionTrabajadores"
	        },
	        feedback:{
				config:{
					block: false
				} 
	        },
	        primaryKey: "id032",
			sortname: "id032",
			sortorder: "asc",
			loadOnStartUp: true
		});
	}
	
	$("#expedientes_feedback").rup_feedback({ 
		type: "ok",
		closeLink: true,
		delay: 1000,
		fadeSpeed: 999999,
		block:true
	});

	$('#calleTrabajo010').removeClass('validate');
	$('#numeroTrabajo010').removeClass('validate');
	$('#cpostalTrabajo010').removeClass('validate');
	$('#fechIniTrabajo010').removeClass('validate');
	$('#duracionDias010').removeClass('validate');
	
	
	$("#expedientes_form").rup_validate({
		feedback:$("#expedientes_feedback"),
		liveCheckingErrors: true,
		rules:{
			"provinciaTrabajo010":{required:function(){
				return mostrarLugarDuracion;}},
			"municipTrabajo010":{required:function(){
				return mostrarLugarDuracion;}},
			"calleTrabajo010":{required:function(){
				return mostrarLugarDuracion;}},
			"numeroTrabajo010":{required:function(){
				return mostrarLugarDuracion;}},
			"cpostalTrabajo010":{required:function(){
				return mostrarLugarDuracion;},digits:true},
			"fechIniTrabajo010":{required:function(){
				return mostrarLugarDuracion;},date:true},
			"duracionDias010":{required:function(){
				return mostrarLugarDuracion;},digits:true},
			"fechaVisita010":{dateTime:true}
		}
	});

	// activamos tooltip
	$("#doc_info").rup_tooltip();
	
	jQuery.validator.addMethod("tipoDocumento", function(value, element, params) {
		var elegido=$("#tipoDoc044_detail_table option[value='"+$("#tipoDoc044_detail_table").val()+"']").text().replace(/[^a-zA-Z]/g,'');
		elegido=elegido.toUpperCase();

		params=elegido;
		if(elegido.indexOf("DNI")>-1){
			return dniMio(value);
		}else if(elegido.indexOf("CIF")>-1){
			return cif(value);
		}else if(elegido.indexOf("NIF")>-1){
			return nif(value);
		}else if(elegido.indexOf("NIE")>-1){
				return validarNie(value);
			
		/*}else{
			return true(value);*/
		}
		return true;
	});
	
	/*$("#trabajadores").on("rupTable_beforeAddRow", function(addOptions){ 
		debugger
		if(duplicado){$("#trabajadores").rup_table("delRowData", "jqg1");}
		
	});
	$("#trabajadores_detail_button_save").bind("click",function(){
		duplicado=true;
	});*/
	$("#fechaAptitud032Str_detail_table").rup_date({
		//datetimepicker:true,
		showSecond: false
	});
	
	$("#imprimirFicha").on("click", imprimir);

	if(esUsuarioModificacion && !estadoCierreRealizado){
		if ($("#docExpSanc").text() != ""){
			// para mostrar la url del dokumento de dokusi 
			//$("#docExpSanc").attr('href', '../../../documento/uploadDokusi?oid=' + oid);
			$("#btn_AdjuntarDocumentoSanc").hide();
			$("#btn_eliminarDocumentoSanc").show();
		} else {
			$("#btn_AdjuntarDocumentoSanc").show();
			$("#btn_eliminarDocumentoSanc").hide();
		}
	}
	
	if(estadoCierreRealizado){
		$("#btn_AdjuntarDocumentoVis").hide();
		$("#btn_EliminarDocumentoVis").hide();
	}else{
		if(esUsuarioModificacion || (!esUsuarioModificacion && esUsuarioModifOsalanTer)){
			if ($("#docVisita").text() != ""){
				// para mostrar la url del dokumento de dokusi 
				//$("#docVisita").attr('href', '../../../documento/uploadDokusi?oid=' + oid);
				$("#btn_AdjuntarDocumentoVis").hide();
				$("#btn_EliminarDocumentoVis").show();
			} else {
				$("#btn_AdjuntarDocumentoVis").show();
				$("#btn_EliminarDocumentoVis").hide();
			}
		}else{
			$("#btn_AdjuntarDocumentoVis").hide();
			$("#btn_EliminarDocumentoVis").hide();
		}
	}
	
	$("#btn_AdjuntarDocumentoVis").click(function(){
		fn_adjuntarDocumento($("#divAdjuntarDocumento"), "docVisita", $("#btn_AdjuntarDocumentoVis"), $("#btn_EliminarDocumentoVis"));
	});	
	
	
	$("#btn_AdjuntarDocumentoSanc").click(function(){
		fn_adjuntarDocumento($("#divAdjuntarDocumento"),"docExpSanc",$("#btn_AdjuntarDocumentoSanc"), $("#btn_eliminarDocumentoSanc"));
	});
	
	$("#btn_eliminarDocumentoSanc").click(function(){
		fn_eliminarDocumento("docExpSanc",$("#btn_AdjuntarDocumentoSanc"), $("#btn_eliminarDocumentoSanc"));
	});	
	
	
	$("#btn_EliminarDocumentoVis").click(function(){
		fn_eliminarDocumento("docVisita", $("#btn_AdjuntarDocumentoVis"), $("#btn_EliminarDocumentoVis"));
	});
	
	$("#trabajadores").on("jqGridAddEditAfterShowForm", function(event,savedData, newData){
		
		$("#idProv010_detail_table").val($("#idProv010").val());
		$("#idAno010_detail_table").val($("#idAno010").val());
		$("#id010_detail_table").val($("#id010").val());
		$("#id047Empresa_detail_table").val($("#id047").val());
		
		var texto=$("#ui-dialog-title-trabajadores_detail_div").html();
		
		if(texto=="Agregar registro"||texto=="Gehitu erregistroa"){
			setTimeout(function(){
				$("#activo033_detail_table").prop("checked",true);
			},100);
			$("#activo033_detail_table").attr("disabled",true);
		}else{
			$("#activo033_detail_table").attr("disabled",false);
		}
		
		$("#id033_detail_table").attr("disabled",true);
		
	});
	
	$("#titulaciones032").keyup(function(){  
        //get the limit from maxlength attribute  
        var limit = parseInt(500);  
        //get the current text inside the textarea  
        var text = $(this).val();  
        //count the number of characters in the text  
        var chars = text.length;  
  
        //check if there are more characters then allowed  
        if(chars > limit){  
            //and if there are use substr to get the text before the limit  
            var new_text = text.substr(0, limit);  
  
            //and change the current text with the new text  
            $(this).val(new_text);  
        }  
    });  
	
	$(".validateDecimal").bind('keypress',function(e){  
        if(e.keyCode == '9' || e.keyCode == '16'){  
              return;  
         }  
         var code;  
         if (e.keyCode) code = e.keyCode;  
         else if (e.which) code = e.which;
         if (code == 8 || code == 46)  
              return true;  
         if (code < 48 || code > 57)  
              return false;  
	 	}  
	); 

$(".validateDecimal").on("paste", function(e) {
	var that = this;
	setTimeout(function() {
		that.value = that.value.replace(",", ".");
        that.value = that.value.replace(/[^0-9\.]+/g, "");
    }, 50);
}); 
	
});

function validarParaCambioPestana(event,tab){
	
	$tabs = $('#tabs').tabs();
	pest_anterior = $tabs.tabs('option', 'selected');
	selected = tab.index;		

	if(pest_anterior!=selected){
		if($("#expedientes_feedback").html()!=''){
			pestanya=pest_anterior;
		}else{
			pestanya=selected;
		}
	}
	tabActiva=pestanya;
}

function requerimiento(event){
	$.rup_messages("msgConfirm", {
		message: $.rup.i18n.app.mensajes.confirmacionRequerimiento,
		title: "",
		OKFunction: function(){
			var idExpediente = $("#idProv010").val()+"/"+$("#idAno010").val()+"/"+$("#id010").val();			
			$.rup_ajax({
				url :  $.rup.CTX_PATH +"expedientes/detalle/tramitacion/crearRequerimiento",
				dataType: 'json',
				data: {"idProvincia":$("#idProv010").val(), "idAno" : $("#idAno010").val(), "idExpediente" : $("#id010").val()},
		    	type: "GET",
		    	contentType: 'application/json',
				success: function (xhr, ajaxOptions) {
					if (xhr.resultado == "error"){
						ab03bUtils.feedback.pintarFeedbackError($.rup.i18nParse($.rup.i18n.app,"mensajes.errorRequerimiento"), $("#expedientes_feedback"));
					} else {
						location.href = $.rup.CTX_PATH + "expedientes/detalle/tramitacion/irTramite/" + idExpediente + "/" + xhr.resultado +"/"+estadoCierreRealizado+"?tab=0";;						
					}
		    	},
				error: function(error){
					ab03bUtils.feedback.pintarFeedbackError(error.responseText, $("#expedientes_feedback"));
				},
				beforeSend : function() {
					ab03bUtils.util.bloquearInterfaz();
				},
				complete: function() {
					ab03bUtils.util.desBloquearInterfaz();
				}
			});			
			

		}
	});
}

function resolucion(event){
	$.rup_messages("msgConfirm", {
		message: $.rup.i18n.app.mensajes.confirmacionResolucion,
		title: "",
		OKFunction: function(){
			var idExpediente = $("#idProv010").val()+"/"+$("#idAno010").val()+"/"+$("#id010").val();
			var url = $.rup.CTX_PATH +"expedientes/detalle/tramitacion/crearResolucion";
			$.rup_ajax({
				url :  url,
				dataType: 'json',
				data: {"idProvincia":$("#idProv010").val(), "idAno" : $("#idAno010").val(), "idExpediente" : $("#id010").val()},
		    	type: "GET",
		    	contentType: 'application/json',
				success: function (xhr, ajaxOptions) {
					if (xhr.resultado == "error"){
						ab03bUtils.feedback.pintarFeedbackError($.rup.i18nParse($.rup.i18n.app,"mensajes.errorResolucion"), $("#expedientes_feedback"));
					} else {
						location.href = $.rup.CTX_PATH + "expedientes/detalle/tramitacion/irTramite/" + idExpediente + "/" + xhr.resultado +"/"+estadoCierreRealizado+"?tab=0";;						
					}
		    	},
				error: function(error){
					ab03bUtils.feedback.pintarFeedbackError(error.responseText, $("#expedientes_feedback"));
				},
				beforeSend : function() {
					ab03bUtils.util.bloquearInterfaz();
				},
				complete: function() {
					ab03bUtils.util.desBloquearInterfaz();
				}
			});			
			

		}
	});
}

function recursoAlzada(event){
	$.rup_messages("msgConfirm", {
		message: $.rup.i18n.app.mensajes.confirmacionRecursoAlzada,
		title: "",
		OKFunction: function(){
			var idExpediente = $("#idProv010").val()+"/"+$("#idAno010").val()+"/"+$("#id010").val();
			var url = $.rup.CTX_PATH +"expedientes/detalle/tramitacion/crearRecursoAlzada";
			$.rup_ajax({
				url :  url,
				dataType: 'json',
				data: {"idProvincia":$("#idProv010").val(), "idAno" : $("#idAno010").val(), "idExpediente" : $("#id010").val()},
		    	type: "GET",
		    	contentType: 'application/json',
				success: function (xhr, ajaxOptions) {
					if (xhr.resultado == "error"){
						ab03bUtils.feedback.pintarFeedbackError($.rup.i18nParse($.rup.i18n.app,"mensajes.errorRecursoAlzada"), $("#expedientes_feedback"));
					} else {
						location.href = $.rup.CTX_PATH + "expedientes/detalle/tramitacion/irTramite/" + idExpediente + "/" + xhr.resultado +"/"+estadoCierreRealizado+"?tab=0";;						
					}
		    	},
				error: function(error){
					ab03bUtils.feedback.pintarFeedbackError(error.responseText, $("#expedientes_feedback"));
				},
				beforeSend : function() {
					ab03bUtils.util.bloquearInterfaz();
				},
				complete: function() {
					ab03bUtils.util.desBloquearInterfaz();
				}
			});			
			

		}
	});
}



function resolDesestimiento(event){
	$.rup_messages("msgConfirm", {
		message: $.rup.i18n.app.mensajes.confirmacionResolDesistimiento,
		title: "",
		OKFunction: function(){
			var idExpediente = $("#idProv010").val()+"/"+$("#idAno010").val()+"/"+$("#id010").val();
			var url = $.rup.CTX_PATH +"expedientes/detalle/tramitacion/crearResolDesestimiento";
			$.rup_ajax({
				url :  url,
				dataType: 'json',
				data: {"idProvincia":$("#idProv010").val(), "idAno" : $("#idAno010").val(), "idExpediente" : $("#id010").val()},
		    	type: "GET",
		    	contentType: 'application/json',
				success: function (xhr, ajaxOptions) {
					if (xhr.resultado == "error"){
						ab03bUtils.feedback.pintarFeedbackError($.rup.i18nParse($.rup.i18n.app,"mensajes.errorResolDesestimiento"), $("#expedientes_feedback"));
					} else {
						location.href = $.rup.CTX_PATH + "expedientes/detalle/tramitacion/irTramite/" + idExpediente + "/" + xhr.resultado +"/"+estadoCierreRealizado+"?tab=0";;						
					}
		    	},
				error: function(error){
					ab03bUtils.feedback.pintarFeedbackError(error.responseText, $("#expedientes_feedback"));
				},
				beforeSend : function() {
					ab03bUtils.util.bloquearInterfaz();
				},
				complete: function() {
					ab03bUtils.util.desBloquearInterfaz();
				}
			});			
			

		}
	});
}

function aportarInforme(event, tipo){
	$.rup_messages("msgConfirm", {
		message: $.rup.i18n.app.mensajes.confirmacionAportarInforme,
		title: "",
		OKFunction: function(){
			var idExpediente = $("#idProv010").val()+"/"+$("#idAno010").val()+"/"+$("#id010").val();
			var url = $.rup.CTX_PATH +"expedientes/detalle/tramitacion/crearAportacionInforme";
			$.rup_ajax({
				url :  url,
				dataType: 'json',
				data: {"idProvincia":$("#idProv010").val(), "idAno" : $("#idAno010").val(), "idExpediente" : $("#id010").val(), "idTipo" : tipo},
		    	type: "GET",
		    	contentType: 'application/json',
				success: function (xhr, ajaxOptions) {
					if (xhr.resultado == "error"){
						ab03bUtils.feedback.pintarFeedbackError($.rup.i18nParse($.rup.i18n.app,"mensajes.errorResolDesestimiento"), $("#expedientes_feedback"));
					} else {
						location.href = $.rup.CTX_PATH + "expedientes/detalle/tramitacion/irTramite/" + idExpediente + "/" + xhr.resultado +"/"+estadoCierreRealizado+"?tab=0";;						
					}
		    	},
				error: function(error){
					ab03bUtils.feedback.pintarFeedbackError(error.responseText, $("#expedientes_feedback"));
				},
				beforeSend : function() {
					ab03bUtils.util.bloquearInterfaz();
				},
				complete: function() {
					ab03bUtils.util.desBloquearInterfaz();
				}
			});			
			

		}
	});
}

function irTramitacion(idExpediente, id014){
	location.href = $.rup.CTX_PATH + "expedientes/detalle/tramitacion/irTramite/" + idExpediente+"/"+id014+"/"+estadoCierreRealizado+"?tab=0";
}

function verOcultarTodos() {
	if ($("div.campoTramite.activoOff").size() >0) {	
		$("div.campoTramite.activoOff").click();
	} else {
		$("div.campoTramite.activoOn").click();
	}
}
	

function modificarExpediente(){
	//$("#expedientes_feedback").rup_feedback("close");
	var reg = new RegExp("\\d{2}-\\d{5}");
	var numRera = $("#numRera047").val();
	if (numRera.length == 0 || reg.test(numRera)){
		//Comprobamos si el número de rera ya existe
		var numReraValid = true;
		if (numRera){
			$.rup_ajax({
				url: $.rup.CTX_PATH + "ab03b10t00/checkNumRera",
				type:"POST",
				data: {	"numRera": numRera, "nifEmpresa" :$("#nifEmpresa047").val()	},
				success: function(response){
					guardarModExpediente();
				}, 
				error: function(error){
					if (error.status === 422){
						pintarFeedbackError($.rup.i18n.app.mensajes.errorNumReraExiste, $("#expedientes_feedback"));
					} else {
						pintarFeedbackError(error.responseText, $("#expedientes_feedback"));
					}
				}
			});
		} else {
			guardarModExpediente();
		}
	} else {
		pintarFeedbackError($.rup.i18n.app.mensajes.errorFormatoNumRera, $("#expedientes_feedback"));
	}
}

function guardarModExpediente(){
	// Llamada ajax para Guardar
	if(ab03bUtils.form.validate($("#expedientes_form"))){
		$.rup_ajax({
			url:  $.rup.CTX_PATH +"ab03b10t00/modificar",
			type: "POST",
			data: JSON.stringify(serializeExpediente()),
			dataType: 'json',
			contentType: 'application/json',
			success: function (mapaRespuesta){
				// Ir al detalle y mostrar un feedback
				//var idExpediente = mapaRespuesta.idProv010+"/"+mapaRespuesta.idAno010+"/"+mapaRespuesta.id010;
				//location.href = $.rup.CTX_PATH + "ab03b10t00/irDetalle/"+idExpediente+"?pestania="+pestanya;
				ab03bUtils.feedback.pintarFeedback($.rup.i18nParse($.rup.i18n.app,"mensajes.okGenerico"),  "ok",$("#expedientes_feedback"));
			},
			error: function(error){
				pintarFeedbackError(error.responseText, $("#expedientes_feedback"));
			},
			complete: function() {
				ab03bUtils.util.desBloquearInterfaz();
			}
		});
	}
}

//Funcion que serializa el Expediente para ser enviado
function serializeExpediente(){
	var fechIniTrabajo010=$("#fechIniTrabajo010").val();
	$("#fechTrab010").val(fechIniTrabajo010);
	
	var fVisita010=$("#fechaVisita010").val();
	$("#fechVisitaInf010").val(fVisita010);
	
	/*var calle047=$("#calle047_label").val();
	$("#calle047").val(calle047);
	
	var calleTrabajo010=$("#calleTrabajo010_label").val();
	$("#calleTrabajo010").val(calleTrabajo010);*/
	
	return $("#expedientes_form").rup_form('formToJson');
}

function cargarCombos(){
	
	if(!estadoCierreRealizado && esUsuarioModificacion){
		//Pestaña 1: Datos de la empresa
		$("#provinciaTrabajo010").rup_combo({
			source:  $.rup.CTX_PATH + "ab03bNora/comboProvincia",
			sourceParam : {label:"desc"+$.rup_utils.capitalizedLang(), value:"code", style:"css"},
			selected:$("#provTrabajo").val(),
			width:150,
			rowStriping:true,
			inputText:true,
			ordered:true
		});
		
	}else{
		//Pestaña 1: Datos de la empresa
		$("#provinciaTrabajo010").rup_combo({
			source:  $.rup.CTX_PATH + "ab03bNora/comboProvincia",
			sourceParam : {label:"desc"+$.rup_utils.capitalizedLang(), value:"code", style:"css"},
			selected:$("#provTrabajo").val(),
			width:150,
			rowStriping:true,
			inputText:true,
			ordered:true,
			disabled:true
		});
		
	}

	$("#id041Material").rup_combo({
		source:  $.rup.CTX_PATH +"ab03b41t00/comboTipoMaterial",
		sourceParam : {label:"desc"+$.rup_utils.capitalizedLang(), value:"code", style:"css"},
		selected:$("#id041").val(),
		width:250,
		rowStriping:true,
		inputText:true,
		ordered:true,
		disabled:true
	});
	
	$("#id054Actividad").rup_combo({
		source:  $.rup.CTX_PATH +"ab03b54t00/comboActividades",
		sourceParam : {label:"desc"+$.rup_utils.capitalizedLang(), value:"code", style:"css"},
		selected:$("#id054").val(),
		width:250,
		rowStriping:true,
		inputText:true,
		ordered:true,
		disabled:true
	});
	
	$("#id055SubActividad").rup_combo({
		source:  $.rup.CTX_PATH +"ab03b55t00/comboSubtipoActividad",
		sourceParam : {label:"desc"+$.rup_utils.capitalizedLang(), value:"code", style:"css"},
		selected:$("#id055").val(),
		width:250,
		rowStriping:true,
		inputText:true,
		ordered:true,
		disabled:true
	});
	
	$('#municipTrabajo010').rup_combo({
		source : "/ab03bAmiantoWar/ab03bNora/comboMunicipioTrabajo",
		sourceParam : {label:"desc"+$.rup_utils.capitalizedLang(), value:"code", style:"css"},
		selected:$("#muniTrabajo").val(),
		width: 300,
		rowStriping:true,
		inputText:true,
		ordered:true,
		parent:["provinciaTrabajo010"],
		change:function(){
			$("#calle010Trabajo_label").data("tmp.loadObjects.term",null);
			//validamos que la calle existe
			if($("#calleTrabajo010").val()!=''){
				var accion="validarCalleCorrectaString/";
				if($.isNumeric($("#calleTrabajo010").val())){
					accion="validarCalleCorrectaId/";
				}
				$.ajax({
					type : "GET",
					url : "/ab03bAmiantoWar/ab03bNora/"+accion,
					data:{
			    		'muni':$("#municipTrabajo010").val(),
			    		'prov':$("#provinciaTrabajo010").val(),
			    		'desc':$("#calleTrabajo010").val()
			    		},
					dataType : "json",
					error : function(jqXHR, textStatus, errorThrown) {
						calleCorrecta= false;
					},
					success : function(data, textStatus, jqXHR) {
						
						if(data==0){
							calleCorrecta= false;
						}
						else{
							calleCorrecta= true;	
						}
					}
				});
			}else{
				calleCorrecta=true;
			}
			// Autocomplete calle
			var urlSource = "/ab03bAmiantoWar/ab03bNora/comboCalle?";
			$("#calleTrabajo010").rup_autocomplete({
				source:urlSource+"prov="+$("#provinciaTrabajo010").val()+"&mun="+$("#municipTrabajo010").val(),
				sourceParam:{
					label:"ds_o",
					value:"id"
				},
				minLength: 1,
				combobox: false,
				select: function(){
					calleCorrecta=true;
				}
			});
		}
	});
	
	//Pestaña 2: Datos de la empresa
	$("#provincia047").rup_combo({
		source:  $.rup.CTX_PATH + "ab03bNora/comboProvinciaTodas",
		sourceParam : {label:"desc"+$.rup_utils.capitalizedLang(), value:"code", style:"css"},
		selected:$("#provSolicitante").val(),
		width:150,
		rowStriping:true,
		inputText:true,
		ordered:true,
		disabled:true
	});
	
	$('#municipio047').rup_combo({
		source : "/ab03bAmiantoWar/ab03bNora/comboMunicipio",
		sourceParam : {label:"desc"+$.rup_utils.capitalizedLang(), value:"code", style:"css"},
		selected:$("#muniSolicitante").val(),
		width: 300,
		rowStriping:true,
		inputText:true,
		ordered:true,
		parent:["provincia047"],
		disabled:true
	});
	
	//Combo Localidad
	$('#localidad047').rup_combo({
		source : "/ab03bAmiantoWar/ab03bNora/comboLocalidad",
		sourceParam : {label:"desc"+$.rup_utils.capitalizedLang(), value:"code", style:"css"},
		selected:$("#locaSolicitante").val(),
		width: 200,
		rowStriping:true,
		inputText:true,
		ordered:true,
		parent:["provincia047","municipio047"],
		disabled: true
	});
	
	$("#tipoDoc044_detail_table").rup_combo({
		source: "/ab03bAmiantoWar/ab03b44t00/comboTipoDoc",
		sourceParam:{
			label:"ds_o",
			value:"id"
		},
		ordered:true,
		style:"dropdown",
		width:150, 
		blank:""
	});
	
	$("#fechIniTrabajo010").rup_date({
		showSecond: false
	});
	
	$("#fechaVisita010").rup_date({
		datetimepicker:true,
		showSecond: false
	});
}

function fncDescargaDocumentoPif(codDocumento){
	window.location.assign($.rup.CTX_PATH + "documento/descargarFichero?codDocumento=" + codDocumento );
}

function irComunicacion(idExpediente, id014){
	window.location.assign($.rup.CTX_PATH + "expedientes/detalle/tramitacion/irTramite/" + idExpediente+"/"+id014+"/"+estadoCierreRealizado+"?tab=1");
}

function imprimir(){
	var idProv = $("#idProv010").val();
	var idAno = $("#idAno010").val();
	var idExp = $("#id010").val();
	
	$.rup_ajax({
		url: $.rup.CTX_PATH + "ab03b10t00/imprimirExpediente?idProv="+idProv+"&idAno="+idAno+"&idExp="+idExp,
		type: "POST",
		dataType: 'json',		
		contentType: 'application/json',
		success: function (){
			window.location = $.rup.CTX_PATH + "ab03b10t00/descargarFicha";
		},
		error: function(error){
		},
		beforeSend : function() {
			ab03bUtils.util.bloquearInterfaz();
		},
		complete: function() {
			ab03bUtils.util.desBloquearInterfaz();
		}
	});	
}

function cerrarExpediente(event){
	$.rup_messages("msgConfirm", {
		message: $.rup.i18n.app.mensajes.confirmacionCierreExpediente,
		title: "",
		OKFunction: function(){
			var idExpediente = $("#idExpediente").val();
			var url = $.rup.CTX_PATH +"expedientes/detalle/tramitacion/cerrarExpediente";
			$.rup_ajax({
				url :  url,
				dataType: 'json',
				data: {"idExpediente":$("#idExpediente").val()},
		    	type: "GET",
		    	contentType: 'application/json',
				success: function (xhr, ajaxOptions) {
					if (xhr.resultado == "error"){
						ab03bUtils.feedback.pintarFeedbackError($.rup.i18nParse($.rup.i18n.app,"mensajes.errorCerrarExpediente"), $("#expedientes_feedback"));
					} else {
						location.href = $.rup.CTX_PATH + "expedientes/detalle/tramitacion/irTramite/" + idExpediente + "/" + xhr.resultado +"/"+estadoCierreRealizado+"?tab=0";;						
					}
		    	},
				error: function(error){
					ab03bUtils.feedback.pintarFeedbackError(error.responseText, $("#expedientes_feedback"));
				},
				beforeSend : function() {
					ab03bUtils.util.bloquearInterfaz();
				},
				complete: function() {
					ab03bUtils.util.desBloquearInterfaz();
				}
			});			
			

		}
	});
}

function dniMio(value){
	value = value.toUpperCase().replace(/\s/, '');
	if (value.length == 9) {
		var dni_letters = "TRWAGMYFPDXBNJZSQVHLCKE";
	    var letter = dni_letters.charAt( parseInt( value, 10 ) % 23 );
	    
	    return letter == value.charAt(8);
		
	} else {
		return false;
	}
}

function pasaporte(value){
	var regsaid = /^[A-PR-WY][1-9]\d\s?\d{4}[1-9]$/ig;
	 
    if(regsaid.test(value) == false)
    {
       return false;
    }
    return true;
}


function validarNie(nie) {
	nie = nie.toUpperCase();
	 
	if (!nie.match('((^[A-Z]{1}[0-9]{7}[A-Z0-9]{1}$|^[T]{1}[A-Z0-9]{8}$)|^[0-9]{8}[A-Z]{1}$)')) {
		return false;
	}
	 
	if (/^[T]{1}/.test(nie)) {
		return (nie[8] === /^[T]{1}[A-Z0-9]{8}$/.test(nie));
	}
	 
	if (/^[XYZ]{1}/.test(nie)) {
		return (
				nie[8] === "TRWAGMYFPDXBNJZSQVHLCKE".charAt(
				nie.replace('X', '0')
				.replace('Y', '1')
				.replace('Z', '2')
				.substring(0, 8) % 23
	   ));
	}
	 
	return false;
}

function cif(value){
	par = 0; 
	non = 0; 
	letras = "ABCDEFGHKLMNPQS"; 
	let = value.charAt(0);   
	if (value.length!=9) { 
		//alert('El Cif debe tener 9 d?gitos'); 
		return false; 
	}   
	if (letras.indexOf(let.toUpperCase())==-1) { 
		//alert("El comienzo del Cif no es v?lido"); 
		return false; 
	}   
	for (zz=2;zz<8;zz+=2) 
	{ 
		par = par+parseInt(value.charAt(zz)); 
	}   
	for (zz=1;zz<9;zz+=2) 
	{ 
		nn = 2*parseInt(value.charAt(zz)); 
		if (nn > 9) 
			nn = 1+(nn-10); 
		non = non+nn; 
	}   
	parcial = par + non; 
	control = (10 - ( parcial % 10)); 
	if (control==10) control=0;   
	if (control!=value.charAt(8)) { 
		//alert("El Cif no es v?lido"); 
		return false; 
	} 
	//alert("El Cif es v?lido"); 
	return true;
}

function nif(value){
	var nie_prefix = value.charAt( 0 );

    switch (nie_prefix) {
      case 'X': nie_prefix = 0; break;
      case 'Y': nie_prefix = 1; break;
      case 'Z': nie_prefix = 2; break;
    }

    return dniMio( nie_prefix + value.substr(1) );
}

function deshabilitarCampos(){
	$('#representanteLegal047').attr("readonly", true);
	
	$('#calleTrabajo010').attr("readonly", true);
	$('#numeroTrabajo010').attr("readonly", true);
	$('#pisoTrabajo010').attr("readonly", true);
	$('#letraTrabajo010').attr("readonly", true);
	$('#cpostalTrabajo010').attr("readonly", true);

	$('#duracionDias010').attr("readonly", true);
	
	$('#expSanc010').attr("readonly", true);
	$("#btn_AdjuntarDocumentoSanc").hide();
	$("#btn_eliminarDocumentoSanc").hide();
	$('#tecnAsign010').attr("readonly", true);
	
	$("#numRera047").attr("readonly", true);
}